<?php

if ( ! function_exists( 'boostup_mikado_map_post_video_meta' ) ) {
	function boostup_mikado_map_post_video_meta() {
		$video_post_format_meta_box = boostup_mikado_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'boostup' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'boostup' ),
				'description'   => esc_html__( 'Choose video type', 'boostup' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'boostup' ),
					'self'            => esc_html__( 'Self Hosted', 'boostup' )
				)
			)
		);
		
		$mkdf_video_embedded_container = boostup_mikado_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'mkdf_video_embedded_container'
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'boostup' ),
				'description' => esc_html__( 'Enter Video URL', 'boostup' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'boostup' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'boostup' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'self'
					)
				)
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'boostup' ),
				'description' => esc_html__( 'Enter video image', 'boostup' ),
				'parent'      => $mkdf_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'mkdf_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'boostup_mikado_action_meta_boxes_map', 'boostup_mikado_map_post_video_meta', 22 );
}