<?php

if ( ! function_exists( 'boostup_mikado_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function boostup_mikado_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'boostup_mikado_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'boostup_mikado_header_standard_meta_map' ) ) {
	function boostup_mikado_header_standard_meta_map( $parent ) {
		$hide_dep_options = boostup_mikado_get_hide_dep_for_header_standard_meta_boxes();
		
		boostup_mikado_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'mkdf_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'boostup' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'boostup' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'boostup' ),
					'center' => esc_html__( 'Center', 'boostup' ),
					'left'   => esc_html__( 'Left', 'boostup' ),
					'right'  => esc_html__( 'Right', 'boostup' )
				),
				'dependency' => array(
					'hide' => array(
						'mkdf_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'boostup_mikado_action_additional_header_area_meta_boxes_map', 'boostup_mikado_header_standard_meta_map' );
}