<?php

if ( ! function_exists( 'boostup_mikado_get_hide_dep_for_header_standard_options' ) ) {
	function boostup_mikado_get_hide_dep_for_header_standard_options() {
		$hide_dep_options = apply_filters( 'boostup_mikado_filter_header_standard_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'boostup_mikado_header_standard_map' ) ) {
	function boostup_mikado_header_standard_map( $parent ) {
		$hide_dep_options = boostup_mikado_get_hide_dep_for_header_standard_options();
		
		boostup_mikado_add_admin_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'set_menu_area_position',
				'default_value'   => 'center',
				'label'           => esc_html__( 'Choose Menu Area Position', 'boostup' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'boostup' ),
				'options'         => array(
					'center' => esc_html__( 'Center', 'boostup' ),
					'right'  => esc_html__( 'Right', 'boostup' ),
					'left'   => esc_html__( 'Left', 'boostup' )
				),
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'boostup_mikado_action_additional_header_menu_area_options_map', 'boostup_mikado_header_standard_map' );
}