<?php

if ( ! function_exists( 'boostup_mikado_sidearea_options_map' ) ) {
	function boostup_mikado_sidearea_options_map() {

        boostup_mikado_add_admin_page(
            array(
                'slug'  => '_side_area_page',
                'title' => esc_html__('Side Area', 'boostup'),
                'icon'  => 'fa fa-indent'
            )
        );

        $side_area_panel = boostup_mikado_add_admin_panel(
            array(
                'title' => esc_html__('Side Area', 'boostup'),
                'name'  => 'side_area',
                'page'  => '_side_area_page'
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_type',
                'default_value' => 'side-menu-slide-from-right',
                'label'         => esc_html__('Side Area Type', 'boostup'),
                'description'   => esc_html__('Choose a type of Side Area', 'boostup'),
                'options'       => array(
                    'side-menu-slide-from-right'       => esc_html__('Slide from Right Over Content', 'boostup'),
                    'side-menu-slide-with-content'     => esc_html__('Slide from Right With Content', 'boostup'),
                    'side-area-uncovered-from-content' => esc_html__('Side Area Uncovered from Content', 'boostup'),
                ),
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'text',
                'name'          => 'side_area_width',
                'default_value' => '',
                'label'         => esc_html__('Side Area Width', 'boostup'),
                'description'   => esc_html__('Enter a width for Side Area (px or %). Default width: 405px.', 'boostup'),
                'args'          => array(
                    'col_width' => 3,
                )
            )
        );

        $side_area_width_container = boostup_mikado_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_width_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_type' => 'side-menu-slide-from-right',
                    )
                )
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'color',
                'name'          => 'side_area_content_overlay_color',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Color', 'boostup'),
                'description'   => esc_html__('Choose a background color for a content overlay', 'boostup'),
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'        => $side_area_width_container,
                'type'          => 'text',
                'name'          => 'side_area_content_overlay_opacity',
                'default_value' => '',
                'label'         => esc_html__('Content Overlay Background Transparency', 'boostup'),
                'description'   => esc_html__('Choose a transparency for the content overlay background color (0 = fully transparent, 1 = opaque)', 'boostup'),
                'args'          => array(
                    'col_width' => 3
                )
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'select',
                'name'          => 'side_area_icon_source',
                'default_value' => 'icon_pack',
                'label'         => esc_html__('Select Side Area Icon Source', 'boostup'),
                'description'   => esc_html__('Choose whether you would like to use icons from an icon pack or SVG icons', 'boostup'),
                'options'       => boostup_mikado_get_icon_sources_array()
            )
        );

        $side_area_icon_pack_container = boostup_mikado_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_icon_pack_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'icon_pack'
                    )
                )
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'        => $side_area_icon_pack_container,
                'type'          => 'select',
                'name'          => 'side_area_icon_pack',
                'default_value' => 'dripicons',
                'label'         => esc_html__('Side Area Icon Pack', 'boostup'),
                'description'   => esc_html__('Choose icon pack for Side Area icon', 'boostup'),
                'options'       => boostup_mikado_icon_collections()->getIconCollectionsExclude(array('linea_icons', 'simple_line_icons'))
            )
        );

        $side_area_svg_icons_container = boostup_mikado_add_admin_container(
            array(
                'parent'     => $side_area_panel,
                'name'       => 'side_area_svg_icons_container',
                'dependency' => array(
                    'show' => array(
                        'side_area_icon_source' => 'svg_path'
                    )
                )
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_icon_svg_path',
                'label'       => esc_html__('Side Area Icon SVG Path', 'boostup'),
                'description' => esc_html__('Enter your Side Area icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'boostup'),
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'      => $side_area_svg_icons_container,
                'type'        => 'textarea',
                'name'        => 'side_area_close_icon_svg_path',
                'label'       => esc_html__('Side Area Close Icon SVG Path', 'boostup'),
                'description' => esc_html__('Enter your Side Area close icon SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'boostup'),
            )
        );

        $side_area_icon_style_group = boostup_mikado_add_admin_group(
            array(
                'parent'      => $side_area_panel,
                'name'        => 'side_area_icon_style_group',
                'title'       => esc_html__('Side Area Icon Style', 'boostup'),
                'description' => esc_html__('Define styles for Side Area icon', 'boostup')
            )
        );

        $side_area_icon_style_row1 = boostup_mikado_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row1'
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_color',
                'label'  => esc_html__('Color', 'boostup')
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row1,
                'type'   => 'colorsimple',
                'name'   => 'side_area_icon_hover_color',
                'label'  => esc_html__('Hover Color', 'boostup')
            )
        );

        $side_area_icon_style_row2 = boostup_mikado_add_admin_row(
            array(
                'parent' => $side_area_icon_style_group,
                'name'   => 'side_area_icon_style_row2',
                'next'   => true
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_color',
                'label'  => esc_html__('Close Icon Color', 'boostup')
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent' => $side_area_icon_style_row2,
                'type'   => 'colorsimple',
                'name'   => 'side_area_close_icon_hover_color',
                'label'  => esc_html__('Close Icon Hover Color', 'boostup')
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'color',
                'name'        => 'side_area_background_color',
                'label'       => esc_html__('Background Color', 'boostup'),
                'description' => esc_html__('Choose a background color for Side Area', 'boostup')
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'      => $side_area_panel,
                'type'        => 'text',
                'name'        => 'side_area_padding',
                'label'       => esc_html__('Padding', 'boostup'),
                'description' => esc_html__('Define padding for Side Area in format top right bottom left', 'boostup'),
                'args'        => array(
                    'col_width' => 3
                )
            )
        );

        boostup_mikado_add_admin_field(
            array(
                'parent'        => $side_area_panel,
                'type'          => 'selectblank',
                'name'          => 'side_area_aligment',
                'default_value' => '',
                'label'         => esc_html__('Text Alignment', 'boostup'),
                'description'   => esc_html__('Choose text alignment for side area', 'boostup'),
                'options'       => array(
                    ''       => esc_html__('Default', 'boostup'),
                    'left'   => esc_html__('Left', 'boostup'),
                    'center' => esc_html__('Center', 'boostup'),
                    'right'  => esc_html__('Right', 'boostup')
                )
            )
        );
    }

    add_action('boostup_mikado_action_options_map', 'boostup_mikado_sidearea_options_map', boostup_mikado_set_options_map_position( 'sidearea' ) );
}