<?php

if ( ! function_exists( 'boostup_mikado_sidebar_options_map' ) ) {
	function boostup_mikado_sidebar_options_map() {
		
		boostup_mikado_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'boostup' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = boostup_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'boostup' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		boostup_mikado_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'boostup' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'boostup' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => boostup_mikado_get_custom_sidebars_options()
		) );
		
		$boostup_custom_sidebars = boostup_mikado_get_custom_sidebars();
		if ( count( $boostup_custom_sidebars ) > 0 ) {
			boostup_mikado_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'boostup' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'boostup' ),
				'parent'      => $sidebar_panel,
				'options'     => $boostup_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'boostup_mikado_action_options_map', 'boostup_mikado_sidebar_options_map', boostup_mikado_set_options_map_position( 'sidebar' ) );
}