<?php

if ( class_exists( 'BoostUpCoreClassWidget' ) ) {
	class BoostUpMikadoClassButtonWidget extends BoostUpCoreClassWidget
	{
		public function __construct()
		{
			parent::__construct(
				'mkdf_button_widget',
				esc_html__('BoostUp Button Widget', 'boostup'),
				array('description' => esc_html__('Add button element to widget areas', 'boostup'))
			);

			$this->setParams();
		}

		protected function setParams()
		{
			$this->params = array(
				array(
					'type' => 'dropdown',
					'name' => 'type',
					'title' => esc_html__('Type', 'boostup'),
					'options' => array(
						'solid' => esc_html__('Solid', 'boostup'),
						'outline' => esc_html__('Outline', 'boostup'),
						'simple' => esc_html__('Simple', 'boostup')
					)
				),
				array(
					'type' => 'dropdown',
					'name' => 'size',
					'title' => esc_html__('Size', 'boostup'),
					'options' => array(
						'small' => esc_html__('Small', 'boostup'),
						'medium' => esc_html__('Medium', 'boostup'),
						'large' => esc_html__('Large', 'boostup'),
						'huge' => esc_html__('Huge', 'boostup')
					),
					'description' => esc_html__('This option is only available for solid and outline button type', 'boostup')
				),
				array(
					'type' => 'textfield',
					'name' => 'text',
					'title' => esc_html__('Text', 'boostup'),
					'default' => esc_html__('Button Text', 'boostup')
				),
				array(
					'type' => 'textfield',
					'name' => 'link',
					'title' => esc_html__('Link', 'boostup')
				),
				array(
					'type' => 'dropdown',
					'name' => 'target',
					'title' => esc_html__('Link Target', 'boostup'),
					'options' => boostup_mikado_get_link_target_array()
				),
				array(
					'type' => 'colorpicker',
					'name' => 'color',
					'title' => esc_html__('Color', 'boostup')
				),
				array(
					'type' => 'colorpicker',
					'name' => 'hover_color',
					'title' => esc_html__('Hover Color', 'boostup')
				),
				array(
					'type' => 'colorpicker',
					'name' => 'background_color',
					'title' => esc_html__('Background Color', 'boostup'),
					'description' => esc_html__('This option is only available for solid button type', 'boostup')
				),
				array(
					'type' => 'colorpicker',
					'name' => 'hover_background_color',
					'title' => esc_html__('Hover Background Color', 'boostup'),
					'description' => esc_html__('This option is only available for solid button type', 'boostup')
				),
				array(
					'type' => 'colorpicker',
					'name' => 'border_color',
					'title' => esc_html__('Border Color', 'boostup'),
					'description' => esc_html__('This option is only available for solid and outline button type', 'boostup')
				),
				array(
					'type' => 'colorpicker',
					'name' => 'hover_border_color',
					'title' => esc_html__('Hover Border Color', 'boostup'),
					'description' => esc_html__('This option is only available for solid and outline button type', 'boostup')
				),
				array(
					'type' => 'colorpicker',
					'name' => 'shadow_color',
					'title' => esc_html__('Box Shadow Color', 'boostup'),
					'description' => esc_html__('This option is only available for solid', 'boostup')
				),

				array(
					'type' => 'textfield',
					'name' => 'margin',
					'title' => esc_html__('Margin', 'boostup'),
					'description' => esc_html__('Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'boostup')
				)
			);
		}

		public function widget($args, $instance)
		{
			$params = '';

			if (!is_array($instance)) {
				$instance = array();
			}

			// Filter out all empty params
			$instance = array_filter($instance, function ($array_value) {
				return trim($array_value) != '';
			});

			// Default values
			if (!isset($instance['text'])) {
				$instance['text'] = 'Button Text';
			}

			// Generate shortcode params
			foreach ($instance as $key => $value) {
				$params .= " $key='$value' ";
			}

			echo '<div class="widget mkdf-button-widget">';
			echo do_shortcode("[mkdf_button $params]"); // XSS OK
			echo '</div>';
		}
	}
}